<?php
if( !class_exists( 'Custom_Error_Pages_Admin' ) )
{
	class Custom_Error_Pages_Admin
	{
		var $options;
		var $slug;
		var $basename;

		function __construct( $args )
		{
			$this->options = $args['options'];
			$this->slug = $args['slug'];
			$this->basename = $args['basename'];
			$this->defaults = $args['defaults'];

			add_action( 'admin_menu' , array( $this, 'plugin_menu' ) );
			add_action( 'admin_init' , array( $this, 'plugin_settings' ) );
		}
		
		function plugin_menu()
		{
			add_filter( 'plugin_action_links_' . $this->basename, array( $this, 'settings_link' ) );
			$plugin_page = add_options_page( __( 'Custom Error Pages', $this->slug ), __( 'Custom Error Pages', $this->slug ), 'manage_options', $this->slug, array( $this, 'plugin_options' ) );
			add_action( 'admin_head-' . $plugin_page, array( $this, 'plugin_panel_styles' ) );
		}

		function settings_link( $links )
		{
			array_unshift( $links, '<a href="' . admin_url( 'options-general.php?page=' . $this->slug ) . '">' . __( 'Settings', $this->slug ) . '</a>' );
			$links[] = '<a href="http://jesin.tk/wordpress-plugins/" target="_blank">' . sprintf( __( 'More Plugins by %s', $this->slug ), 'Jesin'  ) . '</a>';
			return $links;
		}

		function plugin_settings()
		{
			register_setting( $this->slug . '_options', 'jesin_' . $this->slug, array( $this, 'sanitize_input' ) );

			add_settings_section( $this->slug.'_403_settings', sprintf( __( '%s Error Page', $this->slug ), '403' ), array( $this, 'callback_403' ), $this->slug );
			add_settings_field( 'title_403', __( 'Page Title', $this->slug ), array( $this, 'title_403' ), $this->slug, $this->slug . '_403_settings', array( 'label_for' => 'title_403' ) );
			add_settings_field( 'content_403', __( 'Page Content', $this->slug ), array( $this, 'content_403' ), $this->slug, $this->slug . '_403_settings', array( 'label_for' => 'content_403' ) );

			add_settings_section( $this->slug.'_401_settings', sprintf( __( '%s Error Page', $this->slug ), '401' ), array( $this, 'callback_401' ), $this->slug );
			add_settings_field( 'title_401', __( 'Page Title', $this->slug ), array( $this, 'title_401' ), $this->slug, $this->slug . '_401_settings', array( 'label_for' => 'title_401' ) );
			add_settings_field( 'content_401', __( 'Page Content', $this->slug ), array( $this, 'content_401' ), $this->slug, $this->slug . '_401_settings', array( 'label_for' => 'content_401' ) );
		}
		
		function plugin_panel_styles()
		{
			echo '<style type="text/css">#title_403, #title_401 { margin-bottom:5px;padding:3px 8px;font-size:1.7em;line-height:100%;height:1.7em;width:100%;outline:0;margin:1px 0; }</style>';
		}

		function callback_403()
		{
			echo '<a href="' . home_url( '/?status=403' ) . '" target="_blank">Preview</a> this page. (Changes will apply only after you click &quot;Save Changes&quot;)';
		}
		
		function callback_401()
		{
			echo '<a href="' . home_url( '/?status=401' ) . '" target="_blank">Preview</a> this page. (Changes will apply only after you click &quot;Save Changes&quot;)';
		}
		
		function title_403()
		{
			$value = ( isset( $this->options['title_403'] ) && !empty( $this->options['title_403'] ) ) ? $this->options['title_403'] : $this->defaults['title_403'];
			echo '<input id="title_403" type="text" name="jesin_' . $this->slug . '[title_403]" value="' . $value . '"/>';
		}

		function content_403()
		{
			$value = ( isset( $this->options['content_403'] ) && !empty( $this->options['content_403'] ) ) ? $this->options['content_403'] : $this->defaults['content_403'];
			wp_editor( $value, 'content_403', array( 'textarea_name' => 'jesin_' . $this->slug . '[content_403]' ) );
		}

		function title_401()
		{
			$value = ( isset( $this->options['title_401'] ) && !empty( $this->options['title_401'] ) ) ? $this->options['title_401'] : $this->defaults['title_401'];
			echo '<input id="title_401" type="text" name="jesin_' . $this->slug . '[title_401]" value="' . $value . '"/>';
		}

		function content_401()
		{
			$value = ( isset( $this->options['content_401'] ) && !empty( $this->options['content_401'] ) ) ? $this->options['content_401'] : $this->defaults['content_401'];
			wp_editor( $value, 'content_401', array( 'textarea_name' => 'jesin_' . $this->slug . '[content_401]' ) );
		}
		
		function sanitize_input( $input )
		{
			$input['title_403'] = esc_attr( $input['title_403'] );
			$input['title_401'] = esc_attr( $input['title_401'] );
			return $input;
		}
		
		function plugin_options()
		{
		?>
			<div class="wrap">
			<?php screen_icon( ); ?>
			<h2><?php _e( 'Custom Error Pages', $this->slug ); ?></h2>
			<form method="post" action="options.php">
			<?php settings_fields( $this->slug . '_options' ); ?>
			<p><?php printf( __( '%s users place the following in your %s file.', $this->slug ), '<strong>Apache</strong>', '<code>' . get_home_path() . '.htaccess</code>' ); ?><br />
			<pre>ErrorDocument 403 <?php echo str_replace( $_SERVER['DOCUMENT_ROOT'], '', get_home_path() ) . 'index.php?status=403'; ?>

ErrorDocument 401 <?php echo str_replace( $_SERVER['DOCUMENT_ROOT'], '', get_home_path() ) . 'index.php?status=401'; ?></pre></p>
			<p><?php printf( __( '%s users place the following in your %s file.', $this->slug ), '<strong>Nginx</strong>', '<code>nginx.conf</code>' ); ?>
			<pre>error_page	403 = <?php echo str_replace( $_SERVER['DOCUMENT_ROOT'], '', get_home_path() ) . 'index.php?status=403;'; ?>

error_page	401 = <?php echo str_replace( $_SERVER['DOCUMENT_ROOT'], '', get_home_path() ) . 'index.php?status=401;'; ?></pre></p>
			<?php do_settings_sections( $this->slug );
			submit_button(); ?>
			</form>
			</div>
		<?php
		}
	}

	$custom_error_pages_admin = new Custom_Error_Pages_Admin(
								array( 	'basename' => $custom_error_pages_plugin->basename,
										'slug' => $custom_error_pages_plugin->slug,
										'options' => $custom_error_pages_plugin->options,
										'defaults' => $custom_error_pages_plugin->defaults
									)
								);
}